# Version 2.4 - 2.5

This is only a breaking change if you are getting filters for a product listing page with the `EvShop.Controller/Component/ProductsComponent` and including brands. The `_addBrandsToOptionsForListing` method used the product ids from the previous database call to get the option groups to also get the brands. The product ids are now not used to get the brands for the filters as this made an issue with products that didn't have any options not be included in the brand search. To continue to get the correct brands for the filters then you will need to pass any extra parameters into `getOptionFiltersForListing` as brand parameters. An update example in the categories controller would be:

	$filters = $this->Products->getOptionFiltersForListing(
		[
			'joins' => [
				[
					'table' => 'ev_shop_categories_products',
					'alias' => 'CategoryProduct',
					'conditions' => [
						'CategoryProduct.product_id = Product.id'
					]
				]
			],
			'conditions' => [
				'CategoryProduct.category_id' => $id
			]
		],
		true
	);

Would become:

	$filterParameters = [
		'joins' => [
			[
				'table' => 'ev_shop_categories_products',
				'alias' => 'CategoryProduct',
				'conditions' => [
					'CategoryProduct.product_id = Product.id'
				]
			]
		],
		'conditions' => [
			'CategoryProduct.category_id' => $id
		]
	];

	$filters = $this->Products->getOptionFiltersForListing(
		$filterParameters,
		true,
		$filterParameters
	);
